SUBROUTINE integrate ( f, x1, x2, dx, area, error )
!
!  Purpose:
!    To integrate function f(x) between x1 and x2 using
!    rectangles of width dx to approximate the area
!    under the curve f(x).
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    02/15/96    S. J. Chapman        Original code
!
IMPLICIT NONE

! Declare calling arguments:
REAL, EXTERNAL :: f             ! Function to integrate
REAL, INTENT(IN) :: x1          ! Starting point for integral
REAL, INTENT(IN) :: x2          ! Ending point for integral
REAL, INTENT(IN) :: dx          ! Step size
REAL, INTENT(OUT) :: area       ! Area under the curve.
INTEGER, INTENT(OUT) :: error   ! Error flag:
                                !   0 = No error.
                                !   1 = x1 > x2.

! Declare local variables:
REAL :: height                  ! Height of rectangle
INTEGER :: i                    ! Index variable
INTEGER :: n                    ! Number of rectangles to integrate
REAL :: width                   ! Width of rectangle
REAL :: xstart                  ! Starting position of rectangle

! First, check to make sure that x1 <= x2.
errchk: IF ( x1 > x2 ) THEN
   error = 1
ELSE 
   ! Clear error flag and area.
   error = 0
   area = 0
 
   ! Calculate the number of intervals to use.
   n = INT( (x2-x1) / dx + 1. )
 
   ! Calculate and sum the areas of each rectangle.
   sum: DO i = 1, n
      xstart = x1 + REAL(i-1) * dx
      width  = MIN ( dx, x2 - xstart )
      height = f( xstart + width/2. )
      area   = area + width * height
   END DO sum
END IF errchk

END SUBROUTINE integrate
